if exists (select * from sys.procedures where name='sp_mb_XML_AccountingSupplierParty_List')
drop proc sp_mb_XML_AccountingSupplierParty_List
go
---------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[sp_mb_XML_AccountingSupplierParty_List](@Entegrator int)  
 AS   
    
 SELECT  
 SB.VERGINO as "VERGI_NO",   
--'1234567801' as "VERGI_NO",   
 SB.UNVAN as "UNVAN",  
 SB.KapiNo as "KAPI_NO",  
 SB.SokakAdi as "SOKAK_ADI",  
 SB.BinaAdi as "BINA_ADI",  
 SB.BinaNo as "BINA_NO",  
 SB.Ilce as "ILCE",  
 SB.Il as "IL",  
 SB.PostaKodu as "POSTA_KODU",  
 SB.Mahalle as "MAHALLE",  
 SB.UlkeAdi as "ULKE_ADI",  
 SB.VERGIDA as "VERGI_DA",  
 SB.EPosta1 as "EPOSTA",  
 SB.TELNO as "TEL_NO",  
 SB.Faks as "FAKS",   
 SB.EPosta3 AS "MERSIS_NO",  
 SB.OLisansNo AS "TICARET_SICIL_NO",  
 SB.WebSitesi AS "WEB_SITE",  
 EF_SABIT.MAIL_ADRES AS "ETIKET",  
 EF_SABIT.ACIKLAMA AS "ACIKLAMA",   
 EF_SABIT.ACIKLAMA2 AS "ACIKLAMA2",  
 EF_SABIT.ACIKLAMA3 AS "ACIKLAMA3" ,  
 EF_SABIT.IBAN AS "IBAN",  
 SB.Adres1,  
 SB.Adres2  
 FROM ASABIT SB  
INNER JOIN EF_SABIT  ON EF_SABIT.Entegrator=@Entegrator  
GO


---------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_CreditNoteLine_List_delphi')
drop proc sp_mb_XML_CreditNoteLine_List_delphi
go
---------------------------------------------------------------------------

create PROCEDURE [dbo].[sp_mb_XML_CreditNoteLine_List_delphi]       
   /*   
      
   2021 01 15 gncellendi. A.t*/   
   --20230713 tarihinde H.K tarafndan gncellendi.Gruplama iptal edildi. 
 @IslemNo nvarchar(30)       
 AS             
SELECT     
	ROW_NUMBER() OVER (ORDER BY DD.IslemNo3,DD.IslemNo,DD.SiraNo ) SiraNo,  
	DD.StokKodu,       
	DD.StokAdi AS StokAdi,       
	(FaturaMiktari) as Miktar,       
	(SonTutar-DD.KdvTutari)/ DB.DovizKur as KdvsizSatirToplami,       
	(SonTutar-DD.OTVTutari)/ DB.DovizKur as OTVsizSatirToplami,       
	DD.Iskonto1 AS IskOran,       
	((FaturaMiktari* BirimFiyat*BirimMiktar) -DD.Tutar )/ DB.DovizKur as SatirIskontoToplami,       
	(FaturaMiktari* BirimFiyat*BirimMiktar)/ DB.DovizKur  as Isksuz_Satir_Toplami,--tutar       
	DD.Kdv,       
	DD.OTVOrani,       
	(DD.KdvTutari)/ DB.DovizKur as KdvToplami,         
	(DD.OTVTutari)/ DB.DovizKur as OtvToplami,         
	(Birim) as Birim,       
	(DD.Tutar -(SonTutar-DD.KdvTutari))/ DB.DovizKur as Alt_Iskonto_Toplami,        
	(DD.Tutar)/ DB.DovizKur as Tutar,       
	(SonTutar)/ DB.DovizKur as SonTutar,       
	DD.BirimFiyat*DD.BirimMiktar / DB.DovizKur AS ToplamBirimFiyat,--Fiyat       
	CASE WHEN ISNULL (DD.Kdv,0)=0 AND DB.OzelKod1='31' AND DB.YazarKasaFisNo<>2 THEN    '351;Vergiden muaf.'     
	WHEN  ISNULL (DD.Kdv,0)=0 AND DB.OzelKod1='31' AND DB.YazarKasaFisNo=2 THEN   '11/1-a Mal ihracat'    
	when SUBSTRING(ISNULL(DB.OzelKod1,'00'), 1, 1)=3 and ISNULL (DD.Kdv,0)=0 and DB.EF_ISTISNA=0  then '701;11/1-c md. Kapsamndaki hra Kaytl Sat'       
	when DD.TopTutar=0 and DB.EF_ISTISNA=0 then '351;Ksmibedelsiz'    
	WHEN ISNULL (DD.Kdv,0)=0 AND (select top 1  MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')=';'  THEN      
	'351;Vergiden muaf.'    
	WHEN ISNULL (DD.Kdv,0)=0 AND (select top 1  MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')<>';'  THEN    
	(select top 1 MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA) ELSE ''    END  AS  "MUAFIYET",       
	( SELECT top 1 IsoBirimKodu FROM BIRIM b where b.BirimAdi=DD.Birim  )   AS ISO_BIRIM,       
	CASE WHEN DD.Iskonto1 >0 then '%'+CAST(DD.Iskonto1 as varchar(10))    end +       
	CASE WHEN DD.Iskonto2 >0 then  '%'+CAST(DD.Iskonto2 as varchar(10))  else '' end+       
	CASE WHEN DD.Iskonto3 >0 then  '%'+CAST(DD.Iskonto3 as varchar(10))  else '' end+       
	CASE WHEN DD.Iskonto4 >0 then  '%'+CAST(DD.Iskonto4 as varchar(10))  else '' end as "Iskonto_Aciklama"             
from STOKHAR DD        
  JOIN STOKHARDETBAG DB ON  DB.IslemNo in (DD.IslemNo,DD.IslemNo3)    
 where (DD.IslemTuru  in ('Al' ,'Mstahsil'  )  AND DB.FisTuru = 'F' 
AND @IslemNo in (DD.IslemNo, DD.IslemNo3))      
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_CreditNote_TaxSubtotalType_List')
drop proc sp_mb_XML_CreditNote_TaxSubtotalType_List
go
---------------------------------------------------------------------------------------------
create procedure [dbo].[sp_mb_XML_CreditNote_TaxSubtotalType_List](@IslemNo decimal)
as
select   
round(STK.KdvToplami,2) AS "TaxAmount",  
round(STK.SonTutar-STK.KdvToplami,2) AS "TaxableAmount",   
STK.sayi AS "CalculationSequenceNumeric",   
Mustahsil as "Mustahsil_ORANI" ,   
OrjinalKodu,Adi

 FROM  
(SELECT   
sum(1) as sayi,  
sum (FaturaMiktari* BirimFiyat*BirimMiktar* CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END) as Isksuz_Satir_Toplami,  
sum (((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar)* CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END  ) as SatirIskontoToplami,  
cast( sum (((Tutar -(SonTutar-KdvTutari))* CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END )) as decimal(15,2)) as Alt_Iskonto_Toplami,   
sum ((SonTutar-KdvTutari)*CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END) as KdvsizSatirToplami,  
sum (KdvTutari*CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END) as KdvToplami,    
sum(Tutar*CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END) as Tutar,  
sum(SonTutar*CASE WHEN TopTutar>0 THEN (DovizTut/TopTutar) ELSE 0 END) as SonTutar,  
CONVERT(decimal(20,2) , round( km,6))  Mustahsil  ,S.OrjinalKodu,max(S.StokAdi) Adi
 from STOKHAR STK 
 join STOKKARTI S on S.Kodu=STK.StokKodu
 where IslemTuru in ('Mstahsil'  )  
  AND  @IslemNo  in (STK.IslemNo,STK.IslemNo3)  
 -- AND Tutar>0  
 group by km,S.OrjinalKodu) STK; 
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_Customer_List')
drop proc sp_mb_XML_Customer_List
go
---------------------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[sp_mb_XML_Customer_List]
 @IslemNo nvarchar(30)
 AS 


SELECT top 1  
 AMUSTERI.MUSVERNO as "VERGI_NO",
 AMUSTERI.MUSVERGI AS "VERGI_DAIRESI",
--  '7230055623' as "VERGI_NO",
  -- '2234567890' AS "VERGI_NO", 
--'1234567801' AS "VERGI_NO", 
--	AMUSTERI.TCKimlikNo AS "VERGI_NO",
	null as "KAPI_NO",
	AMUSTERI.MUSADRES2  as "SOKAK_ADI",
	null as "BINA_ADI",
	null as "BINA_NO",
	AMUSTERI.MUSILCE  as "ILCE",
	AMUSTERI.MUSIL as "IL",
	null as "POSTA_KODU",
	AMUSTERI.MUSADRES1 as "MAHALLE",
	null as "ULKE_ADI",
	Adres.VergiDairesi as "VERGI_DA",
	AMusteri1.email_1 AS "EPOSTA",
	Adres.Tel1 as "TEL_NO",
	Adres.Faks as "FAKS",
	AMusteri1.WebAdresi_1 as "WEB_SITE", 
    AMUSTERI.MUSADI as "UNVANI",
	CASE WHEN LEN(AMUSTERI.MUSVERNO)>10 THEN AMusteri1.KimlikAdi ELSE NULL END    AS "ADI",
	CASE WHEN LEN(AMUSTERI.MUSVERNO)>10 THEN AMusteri1.KimlikSoyAdi ELSE NULL END     AS "SOYADI",
   -- 'urn:mail:defaultpk@pasaogluyumurta.com' AS "ETIKET" , 
    AMusteri1.email_1 AS "ETIKET",
	RIGHT('0000000000' + CONVERT(VARCHAR,STK.FaturaNo), 9) as "EFATURA_NO", 
    (SELECT '--' + CAST(S.IrsNo AS VARCHAR(MAX)) 
    FROM
	(
	SELECT DISTINCT IrsNo FROM 
	 STOKHARDETBAG S WHERE  S.FaturaNo=STK.FaturaNo and S.IslemNo !=STK.IslemNo  AND S.IrsNo!='' AND S.IrsNo IS NOT NULL
	 )S
    FOR XML PATH(''),TYPE) as "IRSALIYE_NO",
	(SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama') AS  "MUAFIYET",
	--(SELECT Deger FROM Parametre WHERE Param=STK.EF_ISTISNA) AS  "MUAFIYET",
	STK.UUID,
	STK.Ack1 AS "ACIKLAMA1",
	STK.Ack2 AS "ACIKLAMA2",
	STK.Ack3 AS "ACIKLAMA3",
	CASE YazarKasaFisNo WHEN  1 THEN 'TEMELFATURA' WHEN 2 THEN 'IHRACAT' ELSE 'TICARIFATURA' END "FATURA_TUR",    
	CASE SUBSTRING(ISNULL(OzelKod1,'00'), 1, 1) WHEN 0 THEN 'SATIS' WHEN 1 THEN 'TEVKIFAT' WHEN 2 THEN 'IADE' WHEN 3 THEN 'IHRACKAYITLI' WHEN 4 THEN 'ISTISNA'  END  AS "SATIS_TUR",
	SUBSTRING(ISNULL(OzelKod1,'00'), 2, 1) AS "ILETIM_TUR",
    CASE WHEN STK.AltIskYuzde1 >0 THEN  'Alt iskonto oranlar : ' +CONVERT(VARCHAR,STK.AltIskYuzde1) ELSE NULL  END +
	CASE WHEN STK.AltIskYuzde2 >0 THEN   + '|'+CONVERT(VARCHAR,STK.AltIskYuzde2) ELSE NULL END +
	CASE WHEN STK.AltIskYuzde3 >0 THEN   + '|'+CONVERT(VARCHAR,STK.AltIskYuzde3) ELSE NULL  END  as "ALT_ISKONTO_ACIKLAMA",
     DOVIZT.IsoKodu AS "DOVIZ_KODU",
	 (STK.Tutar/STK.DovizTut) AS "DOVIZ_CARPAN"

	--AMusteri1.email_1 as "ETIKT" 
	 --'urn:mail:defaultpk@testkurumelpo.com.tr' AS "ETIKET" 
	--ISNULL(AMusteri1.KimlikAdi,'AD') as "ADI",
	--ISNULL(AMusteri1.KimlikSoyAdi,'SOYAD') as "SOYADI"
 FROM  AMUSTERI 
INNER JOIN  Adres ON AMUSTERI.MUSNO = Adres.CariNo
INNER JOIN STOKHARDETBAG STK ON STK.CariKodu=AMUSTERI.MUSKOD
INNER JOIN AMusteri1 ON AMusteri1.CariNo=AMUSTERI.MUSNO 
INNER JOIN DOVIZT ON  DOVIZT.NoId=STK.DovizCinsi
--INNER JOIN FatAciklama  on  FatAciklama.IslemNo2=STK.IslemNo
WHERE STK.IslemNo=@IslemNo;
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_Customer_List_delphi')
drop proc sp_mb_XML_Customer_List_delphi
go
---------------------------------------------------------------------------------------------
create  procEDURE [dbo].[sp_mb_XML_Customer_List_delphi]               
 @IslemNo nvarchar(30)               
 AS                
               
--- 2022-10-26               
SELECT top 1                 
 Adres.VergiNo as "VERGI_NO",               
 Adres.VergiDairesi AS "VERGI_DAIRESI",               
--  '7230055623' as "VERGI_NO",               
  -- '2234567890' AS "VERGI_NO",                
--'1234567801' AS "VERGI_NO",                
-- AMUSTERI.TCKimlikNo AS "VERGI_NO",               
 null as "KAPI_NO",               
 AMUSTERI.MUSADRES2  as "SOKAK_ADI",               
 null as "BINA_ADI",               
 null as "BINA_NO",               
 AMUSTERI.MUSILCE  as "ILCE",               
 AMUSTERI.MUSIL as "IL",               
 null as "POSTA_KODU",               
 AMUSTERI.MUSADRES1 as "MAHALLE",               
 Adres.Ulke as "ULKE_ADI",               
 Adres.VergiDairesi as "VERGI_DA",               
 AMusteri1.email_1 AS "EPOSTA",               
 Adres.Tel1 as "TEL_NO",               
 Adres.Faks as "FAKS",               
 AMusteri1.WebAdresi_1 as "WEB_SITE",                
    AMUSTERI.MUSADI as "UNVANI",               
 CASE WHEN LEN(AMUSTERI.MUSVERNO)>10 THEN AMusteri1.KimlikAdi ELSE AMUSTERI.MUSADI END    AS "ADI",               
 CASE WHEN LEN(AMUSTERI.MUSVERNO)>10 THEN AMusteri1.KimlikSoyAdi ELSE '' END     AS "SOYADI",               
   -- 'urn:mail:defaultpk@pasaogluyumurta.com' AS "ETIKET" ,                
    AMusteri1.email_1 AS "ETIKET",     
 AMusteri1.email_2 AS "ETIKET_IRSALIYE",     
  STK.FatSerNo+convert(varchar,year(getdate()))+ substring(CONVERT(VARCHAR,STK.FaturaNo),2,len(CONVERT(VARCHAR,STK.FaturaNo)))  as "EFATURA_NO",                  
    (SELECT CAST(S.IrsNo AS VARCHAR(MAX))  +';'   
    FROM               
 (               
select distinct S.IrsNo from STOKHARDETBAG S where   
S.IslemNo in (select IslemNo from STOKHAR WHERE @IslemNo in (IslemNo,IslemNo3)) and FisTuru='I' and S.CariNo=STK.CariNo   
  )S      
  ORDER BY S.IrsNo ASC              
    FOR XML PATH(''),TYPE   ) as "IRSALIYE_NO",    
  (SELECT CAST(S.IrsaliyeTarihi AS VARCHAR(MAX))+';'                
    FROM      
 (SELECT DISTINCT CONVERT(varchar(10), S.FaturaTarihi ,105) IrsaliyeTarihi FROM                
  STOKHARDETBAG S where S.IslemNo in (select IslemNo from STOKHAR WHERE @IslemNo in (IslemNo,IslemNo3)) and FisTuru='I' and S.CariNo=STK.CariNo    
          
  )S      
  ORDER BY S.IrsaliyeTarihi ASC              
    FOR XML PATH(''),TYPE   ) as "IRSALIYE_TARIHI",      
CASE                
WHEN ISNULL (DD.Kdv,0)=0 AND STK.OzelKod1='31' AND STK.YazarKasaFisNo<>2 and STK.EF_ISTISNA=0  THEN    '351;Vergiden muaf.'                 
WHEN  ISNULL (DD.Kdv,0)=0 AND STK.OzelKod1='31' AND STK.YazarKasaFisNo=2 and STK.EF_ISTISNA=0  THEN   '11/1-a Mal ihracat'                
when SUBSTRING(ISNULL(OzelKod1,'00'), 1, 1)=3 and ISNULL (DD.Kdv,0)=0 and STK.EF_ISTISNA=0  then '701;11/1-c md. Kapsamndaki hra Kaytl Sat'                
when DD.TopTutar=0 and STK.EF_ISTISNA=0 then '351;KsmiBedelsiz'            
 WHEN ISNULL (DD.Kdv,0)=0  and ISNULL(STK.EF_ISTISNA,0)=0  THEN   (SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama')                
ELSE (SELECT top 1  MuafiyetKodu+';'+MuafiyetAciklamasi FROM StokVergiMuafiyetleri  WHERE MuafiyetKodu= STK.EF_ISTISNA )           
 END AS  "MUAFIYET",               
 --(SELECT CONVERT(VARCHAR,DEGISKEN_KODU)+'-'+DEGISKEN_ADI FROM EF_DEGISKENLER WHERE DEGISKEN_KODU=STK.EF_ISTISNA) AS  "MUAFIYET",               
 STK.UUID,               
 STK.Ack1 AS "ACIKLAMA1",               
 STK.Ack2 AS "ACIKLAMA2",               
 STK.Ack3 AS "ACIKLAMA3",       
 STK.Ack4 as "ACIKLAMA4",               
 case  when FaturaTipi=6 then 'KAMU' else  CASE YazarKasaFisNo WHEN  1 THEN 'TEMELFATURA' WHEN 2 THEN 'IHRACAT' ELSE 'TICARIFATURA' end END "FATURA_TUR",                   
 CASE  (select top 1 OzelKod1 from STOKHARDETBAG where IslemNo=@IslemNo) WHEN   0    THEN 'SATIS' WHEN   1 THEN 'TEVKIFAT' WHEN 2 THEN 'IADE' 
 WHEN  3 THEN 'IHRACKAYITLI' WHEN  4 THEN 'ISTISNA' else case when STK.FaturaTipi in (5) then 'SATIS' when FaturaTipi=6 and isnull(STK.TevkifatTutari,0)>0 then 'TEVKIFAT' else 'SATIS'  end END  AS "SATIS_TUR",              
 SUBSTRING(ISNULL(OzelKod1,'00'), 2, 1) AS "ILETIM_TUR",               
    CASE WHEN STK.AltIskYuzde1 >0 THEN  'Alt iskonto oranlar : ' +CONVERT(VARCHAR,STK.AltIskYuzde1) ELSE NULL  END +               
 CASE WHEN STK.AltIskYuzde2 >0 THEN   + '|'+CONVERT(VARCHAR,STK.AltIskYuzde2) ELSE NULL END +               
 CASE WHEN STK.AltIskYuzde3 >0 THEN   +          
 '|'+CONVERT(VARCHAR,STK.AltIskYuzde3) ELSE NULL  END  as "ALT_ISKONTO_ACIKLAMA",               
     DOVIZT.IsoKodu AS "DOVIZ_KODU",               
 round((CASE WHEN STK.Tutar=0 AND STK.DovizTut=0 THEN (DD.SonTutar/DD.SonTutarDov) ELSE(STK.Tutar/STK.DovizTut) END),4) AS "DOVIZ_CARPAN",               
  case when Adres.eFaturaMukellefimi='true' then 1 else 0 end EFatura ,               
  AMUSTERI.MUSNO CariNo,   
  STK.FaturaTipi "TIP"   
 --AMusteri1.email_1 as "ETIKT"                
  --'urn:mail:defaultpk@testkurumelpo.com.tr' AS "ETIKET"          
 --ISNULL(AMusteri1.KimlikAdi,'AD') as "ADI",               
 --ISNULL(AMusteri1.KimlikSoyAdi,'SOYAD') as "SOYADI"               
 FROM  AMUSTERI                
INNER JOIN  Adres ON AMUSTERI.MUSNO = Adres.CariNo               
INNER JOIN STOKHARDETBAG STK ON STK.CariKodu=AMUSTERI.MUSKOD               
JOIN STOKHAR DD ON DD.IslemNo=STK.IslemNo               
INNER JOIN AMusteri1 ON AMusteri1.CariNo=AMUSTERI.MUSNO                
INNER JOIN DOVIZT ON  DOVIZT.NoId=STK.DovizCinsi               
--INNER JOIN FatAciklama  on  FatAciklama.IslemNo2=STK.IslemNo               
WHERE (@IslemNo in(DD.IslemNo,DD.IslemNo3) and STK.FaturaAdresNo=Adres.AdresNo) ; 

GO

---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_DespatchAdvice_List')
drop proc sp_mb_XML_DespatchAdvice_List
go
---------------------------------------------------------------------------------------------
create procedure [dbo].[sp_mb_XML_DespatchAdvice_List]    
 @IslemNo nvarchar(30)    
 AS      
 SELECT    
 ROW_NUMBER() OVER (ORDER BY LST.StokKodu ) "SiraNo"  ,    
 LST.StokKodu,    
 LST.StokAdi,    
 LST.IskOran,  --LST.IskOran,    
 LST.Kdv,    
 LST.Birim,    
 LST.ISO_BIRIM,    
 LST.MUAFIYET,    
 LST.ToplamBirimFiyat,    
 round(SUM(LST.Miktar),2) Miktar,    
 round(SUM(LST.KdvsizSatirToplami),2) KdvsizSatirToplami,    
round( SUM(LST.SatirIskontoToplami) ,2)SatirIskontoToplami,    
 round(SUM(LST.Isksuz_Satir_Toplami) ,2)Isksuz_Satir_Toplami,    
 round(SUM(LST.KdvToplami) ,2)KdvToplami,    
 round(SUM(LST.Alt_Iskonto_Toplami),2) Alt_Iskonto_Toplami,    
 round(SUM(LST.Tutar),2) Tutar,    
 round(SUM(LST.SonTutar),2) SonTutar,     
 LST.Iskonto_Aciklama    
 FROM(    
SELECT     
     
DD.StokKodu,    
DD.StokAdi AS StokAdi,    
(FaturaMiktari) as Miktar,    
case when TopTutar>0 then (SonTutar-KdvTutari)*(DovizTut/TopTutar) else 0 end  as KdvsizSatirToplami,--Net tutar    
DD.Iskonto1 AS IskOran,    
case when Tutar>0 then ((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar )*(DovizTut/TopTutar) else 0 end as SatirIskontoToplami,    
case when DovizTut>0 then (FaturaMiktari* BirimFiyat*BirimMiktar)*(DovizTut/TopTutar) else 0 end  as Isksuz_Satir_Toplami,--tutar    
 DD.Kdv,    
(KdvTutari)*(DovizTut/TopTutar) as KdvToplami,      
(Birim) as Birim,    
case when DovizTut>0 then (Tutar -(SonTutar-KdvTutari))*(DovizTut/TopTutar) else 0  end as Alt_Iskonto_Toplami,     
case when TopTutar>0 then (Tutar)*(DovizTut/TopTutar) else 0 end as Tutar,    
case when TopTutar >0 then (SonTutar)*(DovizTut/TopTutar) else 0 end as SonTutar,    
case when TopTutar>0 then DD.BirimFiyat*DD.BirimMiktar*(DovizTut/TopTutar) else 0 end AS ToplamBirimFiyat,--Fiyat    
CASE WHEN ISNULL (DD.Kdv,0)=0 THEN (SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama') ELSE '' END AS  "MUAFIYET",    
 ( SELECT IsoBirimKodu FROM BIRIM b where b.BirimAdi=DD.Birim  )   AS ISO_BIRIM,    
 CASE WHEN DD.Iskonto1 >0 then '%'+CAST(DD.Iskonto1 as varchar(10))    end +    
 CASE WHEN DD.Iskonto2 >0 then  '%'+CAST(DD.Iskonto2 as varchar(10))  else '' end+    
 CASE WHEN DD.Iskonto3 >0 then  '%'+CAST(DD.Iskonto3 as varchar(10))  else '' end+    
 CASE WHEN DD.Iskonto4 >0 then  '%'+CAST(DD.Iskonto4 as varchar(10))  else '' end as "Iskonto_Aciklama"    
    
from STOKHAR DD  where  1=1    
AND @IslemNo  in(DD.IslemNo, DD.IslemNo3)    
AND (Tutar >0   or FaturaMiktari>0)  
)LST    
GROUP BY     
LST.StokKodu,    
LST.StokAdi,    
LST.IskOran,    
LST.Kdv,    
LST.Birim,    
LST.ISO_BIRIM,    
LST.MUAFIYET,    
LST.ToplamBirimFiyat,    
Iskonto_Aciklama; 
GO

---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_FaturaList')
drop proc sp_mb_XML_FaturaList
go
---------------------------------------------------------------------------------------------
CREATE PROCEDURE  [dbo].[sp_mb_XML_FaturaList]
 @MusKod nvarchar(100),
 @V_ILKTARIH  DATETIME,
 @V_SONTARIH  DATETIME,
 @V_TUR nvarchar(100),
 @V_SERI_NO nvarchar(100)
 AS 

SELECT 
STK.IslemNo AS "ISLEMNO",
STK.CariKodu AS "CARIKODU",
STK.CariAdi AS "CARIADI",
STK.Tutar AS "TUTAR",
STK.FaturaNo AS "FATURANO",
STK.eFaturaDurumu AS "DURUMU",
AMUS.email_1 AS	"MAIL",
STK.FaturaTarihi AS "FATURATARIHI",
--GETDATE() AS "FATURATARIHI"	,
STK.FatSerNo AS "SERI_NO",
CONVERT(varchar,eFaturaGonderimTarihi,104) +'/'+STK.UUID as "FAT_YOL",
CONVERT(varchar,eFaturaGonderimTarihi,104) AS "EFATURAGONDERIMTARIH"

--'28.01.2020/11d5f9e5-a44a-4649-9007-2d610a8fd116' as "FAT_YOL"
--MUS.TCKimlikNo AS "MUS_VERGI_NO",
--SB.VERGINO AS "FRM_VERGI_NO",
--'urn:mail:defaultgb@testkurumelpo.com.tr' AS "GONDERICI_ETIKET",
--'urn:mail:defaultpk@testkurumelpo.com.tr' AS "ALICI_ETIKET"
FROM
STOKHARDETBAG STK
INNER JOIN Adres AD ON AD.CariKodu=STK.CariKodu
INNER JOIN AMusteri1 AMUS ON AMUS.CariNo=STK.CariNo 
INNER JOIN AMUSTERI MUS ON STK.CariKodu=MUS.MUSKOD  
--INNER JOIN ASABIT SB ON 1=1
WHERE 
MUS.MUSVERNO IS NOT NULL AND MUS.MUSVERNO <>'' AND 
AD.AdresNo=STK.FaturaAdresNo AND STK.FatSerNo LIKE '%'+@V_SERI_NO+'%' AND
((( CONVERT(datetime,FaturaTarihi,104) BETWEEN  CONVERT(datetime,@V_ILKTARIH,104) AND CONVERT(datetime,@V_SONTARIH,104)+1)
OR (@V_ILKTARIH IS NULL AND convert(varchar,STK.FaturaTarihi,23)>convert(varchar, getdate()-10, 23) )
)AND (IslemTuru ='Sat' or IslemTuru ='Al ade'  ) and FisTuru='F')
AND
(
	( 
		(
		(@V_TUR IS NULL OR @V_TUR ='' AND (UUID IS NULL OR UUID=''  OR  eFaturaDurumu = 'Reddedildi' OR  eFaturaDurumu = 'Gonderilemedi' ))  
		OR (@V_TUR ='1' AND UUID IS NOT NULL AND eFaturaDurumu = 'Gib e iletildi')  
		OR (@V_TUR ='2' AND UUID IS NOT NULL AND eFaturaDurumu = 'Onay Bekliyor') 
		OR (@V_TUR ='3' AND UUID IS NOT NULL AND eFaturaDurumu = 'Reddedildi' ) 
		OR (@V_TUR ='4' AND UUID IS NOT NULL AND eFaturaDurumu = 'Onayland' )
		)
		AND AD.eFaturaMukellefimi ='true' 
	) 
	OR
	(
		(
	      (@V_TUR ='10' AND  (UUID IS NULL OR UUID=''  OR  eFaturaDurumu = 'Fatura ptal' OR  eFaturaDurumu = 'Gonderilemedi' ))
		  OR (@V_TUR ='11' AND UUID IS NOT NULL AND eFaturaDurumu = 'Fatura Kayt Edildi') 
		  OR (@V_TUR ='12' AND UUID IS NOT NULL AND eFaturaDurumu = 'Fatura ptal' ) 
		)
	AND AD.eFaturaMukellefimi <>'true' 
	)
)
order by FaturaTarihi asc;
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_InvoiceLine_List')
drop proc sp_mb_XML_InvoiceLine_List
go
---------------------------------------------------------------------------------------------
create procedure [dbo].[sp_mb_XML_InvoiceLine_List] 
 @IslemNo nvarchar(30) 
 as 
SELECT 
	ROW_NUMBER() OVER (ORDER BY LST.StokKodu ) "SiraNo"  , 
	LST.StokKodu, 
	LST.StokAdi, 
	LST.IskOran,   
	LST.Kdv, 
	LST.Birim, 
	LST.ISO_BIRIM, 
	LST.MUAFIYET, 
	LST.ToplamBirimFiyat, 
	SUM(LST.Miktar) Miktar, 
	SUM(LST.KdvsizSatirToplami) KdvsizSatirToplami, 
	SUM(LST.SatirIskontoToplami) SatirIskontoToplami, 
	SUM(LST.Isksuz_Satir_Toplami) Isksuz_Satir_Toplami, 
	SUM(LST.KdvToplami) KdvToplami, 
	SUM(LST.Alt_Iskonto_Toplami) Alt_Iskonto_Toplami, 
	SUM(LST.Tutar) Tutar, 
	SUM(LST.SonTutar) SonTutar,  
	LST.Iskonto_Aciklama 
 FROM( 
SELECT  
  
DD.StokKodu, 
DD.StokAdi AS StokAdi, 
(FaturaMiktari) as Miktar, 
(SonTutar-KdvTutari)/(DovizKuru) as KdvsizSatirToplami, 
DD.Iskonto1 AS IskOran, 
((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar )/(DovizKuru) as SatirIskontoToplami, 
(FaturaMiktari* BirimFiyat*BirimMiktar)/(DovizKuru) as Isksuz_Satir_Toplami,--tutar 
 DD.Kdv, 
(KdvTutari)/(DovizKuru) as KdvToplami,   
(Birim) as Birim, 
(Tutar -(SonTutar-KdvTutari))/(DovizKuru) as Alt_Iskonto_Toplami,  
(Tutar)/((DovizKuru)) as Tutar, 
(SonTutar)/((DovizKuru)) as SonTutar, 
(DD.BirimFiyat*DD.BirimMiktar)/(DovizKuru) AS ToplamBirimFiyat,--Fiyat 
CASE WHEN ISNULL (DD.Kdv,0)=0 THEN (SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama') ELSE '' END AS  "MUAFIYET", 
 ( SELECT IsoBirimKodu FROM BIRIM b where b.BirimAdi=DD.Birim  )   AS ISO_BIRIM, 
 CASE WHEN DD.Iskonto1 >0 then '%'+CAST(DD.Iskonto1 as varchar(10))    end + 
 CASE WHEN DD.Iskonto2 >0 then  '%'+CAST(DD.Iskonto2 as varchar(10))  else '' end+ 
 CASE WHEN DD.Iskonto3 >0 then  '%'+CAST(DD.Iskonto3 as varchar(10))  else '' end+ 
 CASE WHEN DD.Iskonto4 >0 then  '%'+CAST(DD.Iskonto4 as varchar(10))  else '' end as Iskonto_Aciklama 
 
from STOKHAR DD  where (IslemTuru ='Sat' or IslemTuru ='Al ade'  ) 
AND (DD.IslemNo=@IslemNo or DD.IslemNo3=@IslemNo) 
AND Tutar >0  
)LST 
GROUP BY  
LST.StokKodu, 
LST.StokAdi, 
LST.IskOran, 
LST.Kdv, 
LST.Birim, 
LST.ISO_BIRIM, 
LST.MUAFIYET, 
LST.ToplamBirimFiyat, 
Iskonto_Aciklama
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_InvoiceLine_List_Grup')
drop proc sp_mb_XML_InvoiceLine_List_Grup
go
---------------------------------------------------------------------------------------------
CREATE   procedure [dbo].[sp_mb_XML_InvoiceLine_List_Grup] -- @IslemNo  
 @IslemNo nvarchar(30)     
AS        
 SELECT       
 ROW_NUMBER() OVER (ORDER BY LST.StokKodu ) "SiraNo"  ,       
 LST.StokKodu,       
 LST.StokAdi,       
 LST.IskOran,         
 LST.Kdv,       
 LST.Birim,       
 LST.ISO_BIRIM,       
 LST.MUAFIYET,       
 SUM(LST.Tutar)/SUM(LST.Miktar) ToplamBirimFiyat,       
 SUM(LST.Miktar) Miktar,       
 SUM(LST.KdvsizSatirToplami) KdvsizSatirToplami,       
 SUM(LST.SatirIskontoToplami) SatirIskontoToplami,       
 SUM(LST.Isksuz_Satir_Toplami) Isksuz_Satir_Toplami,       
 SUM(LST.KdvToplami) KdvToplami,       
 SUM(LST.Alt_Iskonto_Toplami) Alt_Iskonto_Toplami,       
 SUM(LST.Tutar) Tutar,       
 SUM(LST.SonTutar) SonTutar,        
 LST.Iskonto_Aciklama,     
  MAX(LST.OTVOrani) OTVOrani,         
 sum(LST.OTVsizSatirToplami) OTVsizSatirToplami,         
 sum(LST.OtvToplami) OtvToplami         
 FROM(       
SELECT        
	DD.StokKodu,       
	DD.StokAdi AS StokAdi,       
	sum (FaturaMiktari) as Miktar,       
	sum ((SonTutar-DD.KdvTutari) / (DovizKuru)) as KdvsizSatirToplami,       
	DD.Iskonto1 AS IskOran,       
	sum (((FaturaMiktari* BirimFiyat*BirimMiktar) -DD.Tutar ) / (DovizKuru) ) as SatirIskontoToplami,       
	sum(((FaturaMiktari* BirimFiyat*BirimMiktar) / (DovizKuru) )) as Isksuz_Satir_Toplami,--tutar       
	 DD.Kdv,       
	sum ((DD.KdvTutari) / (DovizKuru)) as KdvToplami,         
	(Birim) as Birim,       
	(SUM((DD.SonTutar-DD.OTVTutari)/ DovizKuru)) as OTVsizSatirToplami,        
	sum ((DD.Tutar -(SonTutar-DD.KdvTutari)) /(DovizKuru)) as Alt_Iskonto_Toplami,        
	sum ((DD.Tutar) /DovizKuru) as Tutar,       
	sum ((SonTutar) / DovizKuru) as SonTutar,       
	sum ((DD.BirimFiyat*DD.BirimMiktar) / DovizKuru) AS ToplamBirimFiyat,--Fiyat       
	CASE WHEN ISNULL (DD.Kdv,0)=0 AND MAX(DB.OzelKod1)='31' AND MAX(DB.YazarKasaFisNo)<>2 THEN    '351;Vergiden muaf.'       
	WHEN  ISNULL (DD.Kdv,0)=0 AND MAX(DB.OzelKod1)='31' AND MAX(DB.YazarKasaFisNo)=2 THEN   '11/1-a Mal ihracat'      
	when SUBSTRING(ISNULL(MAX(DB.OzelKod1),'00'), 1, 1)=3 and ISNULL (DD.Kdv,0)=0 and DB.EF_ISTISNA=0  then '701;11/1-c md. Kapsamndaki hra Kaytl Sat'         
	when SUM(DD.TopTutar)=0 and MAX(DB.EF_ISTISNA)=0 then '351;Ksmibedelsiz'      
	 WHEN ISNULL (DD.Kdv,0)=0 AND (select MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')=';'  THEN        
		'351;Vergiden muaf.'      
	 WHEN ISNULL (DD.Kdv,0)=0 AND (select MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')<>';'  THEN      
	  (select MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA) ELSE ''    END  AS  "MUAFIYET",     
	 ( SELECT IsoBirimKodu FROM BIRIM b where b.BirimAdi=DD.Birim  )   AS ISO_BIRIM,       
	 CASE WHEN DD.Iskonto1 >0 then '%'+CAST(DD.Iskonto1 as varchar(10))    end +       
	 CASE WHEN DD.Iskonto2 >0 then  '%'+CAST(DD.Iskonto2 as varchar(10))  else '' end+       
	 CASE WHEN DD.Iskonto3 >0 then  '%'+CAST(DD.Iskonto3 as varchar(10))  else '' end+       
	 CASE WHEN DD.Iskonto4 >0 then  '%'+CAST(DD.Iskonto4 as varchar(10))  else '' end as Iskonto_Aciklama,     
	  DD.OTVOrani,     
	  SUM((DD.OTVTutari)/ DB.DovizKur) as OtvToplami               
	from STOKHAR DD       
	 JOIN STOKHARDETBAG DB ON  DB.IslemNo in (DD.IslemNo,DD.IslemNo3)   
	where  DB.FisTuru = 'F'     
	AND (@IslemNo in (DD.IslemNo3,DD.IslemNo))    
	--AND DD.Tutar >0    
	group by StokKodu,StokAdi,Iskonto1,Kdv,Birim,Iskonto2,Iskonto3,Iskonto4,EF_ISTISNA,DD.OTVOrani     
)LST       
GROUP BY        
LST.StokKodu,       
LST.StokAdi,       
LST.IskOran,       
LST.Kdv,       
LST.Birim,       
LST.ISO_BIRIM,       
LST.MUAFIYET,       
LST.ToplamBirimFiyat,       
Iskonto_Aciklama
GO

---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_InvoiceLine_List_delphi')
drop proc sp_mb_XML_InvoiceLine_List_delphi
go
---------------------------------------------------------------------------------------------
CREATE   PROCEDURE [dbo].[sp_mb_XML_InvoiceLine_List_delphi]       
   /*   
      
   2021 01 15 gncellendi. A.t*/   
   --20230713 tarihinde H.K tarafndan gncellendi.Gruplama iptal edildi. 
 @IslemNo nvarchar(30)       
 AS             
SELECT     
	ROW_NUMBER() OVER (ORDER BY DD.IslemNo3,DD.IslemNo,DD.SiraNo ) SiraNo,  
	DD.StokKodu,       
	DD.StokAdi AS StokAdi,       
	(FaturaMiktari) as Miktar,       
	(SonTutar-DD.KdvTutari)/ DB.DovizKur as KdvsizSatirToplami,       
	(SonTutar-DD.OTVTutari)/ DB.DovizKur as OTVsizSatirToplami,       
	DD.Iskonto1 AS IskOran,       
	((FaturaMiktari* BirimFiyat*BirimMiktar) -DD.Tutar )/ DB.DovizKur as SatirIskontoToplami,       
	(FaturaMiktari* BirimFiyat*BirimMiktar)/ DB.DovizKur  as Isksuz_Satir_Toplami,--tutar       
	DD.Kdv,       
	DD.OTVOrani,       
	(DD.KdvTutari)/ DB.DovizKur as KdvToplami,         
	(DD.OTVTutari)/ DB.DovizKur as OtvToplami,         
	(Birim) as Birim,       
	(DD.Tutar -(SonTutar-DD.KdvTutari))/ DB.DovizKur as Alt_Iskonto_Toplami,        
	(DD.Tutar)/ DB.DovizKur as Tutar,       
	(SonTutar)/ DB.DovizKur as SonTutar,       
	DD.BirimFiyat*DD.BirimMiktar / DB.DovizKur AS ToplamBirimFiyat,--Fiyat       
	CASE WHEN ISNULL (DD.Kdv,0)=0 AND DB.OzelKod1='31' AND DB.YazarKasaFisNo<>2 THEN    '351;Vergiden muaf.'     
	WHEN  ISNULL (DD.Kdv,0)=0 AND DB.OzelKod1='31' AND DB.YazarKasaFisNo=2 THEN   '11/1-a Mal ihracat'    
	when SUBSTRING(ISNULL(DB.OzelKod1,'00'), 1, 1)=3 and ISNULL (DD.Kdv,0)=0 and DB.EF_ISTISNA=0  then '701;11/1-c md. Kapsamndaki hra Kaytl Sat'       
	when DD.TopTutar=0 and DB.EF_ISTISNA=0 then '351;Ksmibedelsiz'    
	WHEN ISNULL (DD.Kdv,0)=0 AND (select top 1  MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')=';'  THEN      
	'351;Vergiden muaf.'    
	WHEN ISNULL (DD.Kdv,0)=0 AND (select top 1  MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA and MuafiyetKodu<>'000')<>';'  THEN    
	(select top 1 MuafiyetKodu+';'+MuafiyetAciklamasi from StokVergiMuafiyetleri where StokKodu=DD.StokKodu and MuafiyetKodu=DB.EF_ISTISNA) ELSE ''    END  AS  "MUAFIYET",       
	( SELECT top 1 IsoBirimKodu FROM BIRIM b where b.BirimAdi=DD.Birim  )   AS ISO_BIRIM,       
	CASE WHEN DD.Iskonto1 >0 then '%'+CAST(DD.Iskonto1 as varchar(10))    end +       
	CASE WHEN DD.Iskonto2 >0 then  '%'+CAST(DD.Iskonto2 as varchar(10))  else '' end+       
	CASE WHEN DD.Iskonto3 >0 then  '%'+CAST(DD.Iskonto3 as varchar(10))  else '' end+       
	CASE WHEN DD.Iskonto4 >0 then  '%'+CAST(DD.Iskonto4 as varchar(10))  else '' end as "Iskonto_Aciklama"             
from STOKHAR DD        
  JOIN STOKHARDETBAG DB ON  DB.IslemNo in (DD.IslemNo,DD.IslemNo3)    
 where  DB.FisTuru = 'F' 
AND @IslemNo in (DD.IslemNo, DD.IslemNo3)      
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_StokHarDurumUpdate')
drop proc sp_mb_XML_StokHarDurumUpdate
go
---------------------------------------------------------------------------------------------

CREATE  PROCEDURE	[dbo].[sp_mb_XML_StokHarDurumUpdate] 
	@IslemNo int,
	@eFaturaGonderimTarihi DateTime, 
	@eFaturaDurumu nvarchar(20),
	@UUID nvarchar(60)
AS 
update STOKHARDETBAG
 set
  UUID=@UUID, 
  eFaturaGonderimTarihi=@eFaturaGonderimTarihi,	
  eFaturaDurumu=@eFaturaDurumu  
  where   IslemNo=@IslemNo;
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_StokHarDurumUpdateDelphi')
drop proc sp_mb_XML_StokHarDurumUpdateDelphi
go
---------------------------------------------------------------------------------------------
CREATE  PROCEDURE [dbo].[sp_mb_XML_StokHarDurumUpdateDelphi]       
/* 2020 01 16 a.t gncelleme fatno*/  
/*2021 07 17 a.t entegrator*/  
 @IslemNo int,      
 @eFaturaGonderimTarihi DateTime,       
 @eFaturaDurumu nvarchar(20),      
 @UUID nvarchar(60),      
 @Efaturano nvarchar(60)='',  
 @Entegrator int=0,  
 @ProcessType int=1  
AS       
update STK      
 set      
 
    IRSALIYEUUID= CASE WHEN  @ProcessType=3  THEN   @UUID ELSE IRSALIYEUUID END  ,      
   UUID= CASE WHEN  @ProcessType<>3  THEN   @UUID ELSE UUID END  ,  
  eFaturaGonderimTarihi=@eFaturaGonderimTarihi,       
  EIRSALIYEDURUM= CASE WHEN  @ProcessType=3  THEN   @eFaturaDurumu ELSE EIRSALIYEDURUM END  ,      
   eFaturaDurumu= CASE WHEN  @ProcessType<>3  THEN   @eFaturaDurumu ELSE eFaturaDurumu END  ,  
  eFaturaNo=case when @ProcessType<>3 then  @Efaturano   else '' end,  
 IrsNo= case when @ProcessType=3 and @Efaturano<>'' then right (@eFaturaNo,9)  else IrsNo  end  
 ,EIrsaliyeNo=case when @ProcessType=3 then  @Efaturano else EIrsaliyeNo end
 ,FatSerNo=case when @ProcessType<>3 and @Efaturano<>'' then  convert(varchar(3),left(@Efaturano,3)) else FatSerNo   end  
 ,STK.FaturaNo=case when @ProcessType<>3 and  @Efaturano<>'' then  right (@eFaturaNo,9) else STK.FaturaNo end  
 ,Entegrator=@Entegrator  
 from STOKHARDETBAG STK  
  
  where   (STK.IslemNo=@IslemNo OR STK.IslemNo3=@IslemNo);  
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_StokHarDurumUpdateUUID')
drop proc sp_mb_XML_StokHarDurumUpdateUUID
go
---------------------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[sp_mb_XML_StokHarDurumUpdateUUID]     
 @eFaturaDurumu nvarchar(20),   
 @UUID nvarchar(60),   
 @eFaturaNo nvarchar(20)   
AS    
declare @IslemNo int; 
 
Select @IslemNo = IslemNo FRom STOKHARDETBAG where UUID=@UUID 
 
UPDATE STOKHARDETBAG   
   SET eFaturaDurumu=@eFaturaDurumu,   
       eFaturaNo=  @eFaturaNo   
 WHERE UUID=@UUID; 
 
UPDATE ACARI  
   SET ACIKLAMA = @eFaturaNo + ' no.lu Fatura'  
 WHERE ISLEMNO = @IslemNo;
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_TaxLegalMonetary_List')
drop proc sp_mb_XML_TaxLegalMonetary_List
go
---------------------------------------------------------------------------------------------
CREATE      PROCEDURE  [dbo].[sp_mb_XML_TaxLegalMonetary_List]              
 @IslemNo nvarchar(30)              
 as          
 ;with mustahsil as (          
select isnull(sum(DovizTut),0) MustahsilTut from STOKHAR where IslemTuru='Mstahsil' and  IslemNo=@IslemNo           
)             
select            
           
round(STK.KdvToplami,2) AS "TaxAmount",              
round(STK.SonTutar,2)   
AS "TaxableAmount",              
--round(STK.KdvToplami,2)) AS "TaxAmount",              
STK.sayi AS "CalculationSequenceNumeric",              
round(STK.Isksuz_Satir_Toplami,2) AS  "LineExtensionAmount",              
(round(STK.KdvsizSatirToplami,2)) AS "TaxExclusiveAmount",              
--(round(STK.SonTutar,2))  
round(STK.Isksuz_Satir_Toplami,2)+round(STK.KdvToplami,2) AS "TaxInclusiveAmount",              
(round(STK.SatirIskontoToplami+Alt_Iskonto_Toplami,2)) AS "AllowanceTotalAmount",              
(round(STK.SonTutar,2)-(select MustahsilTut from mustahsil )) AS "PayableAmount",              
isnull(TevkifatKod,'') as TevkifatKod,              
isnull(TevkifatAd,'') as TevkifatAd,isnull(TevkifatOrani,0) TevkifatOrani,isnull(TevkifatTutari,0) TevkifatTutari              
            
 FROM              
(SELECT               
sum(1) as sayi,              
sum (FaturaMiktari* BirimFiyat*BirimMiktar/STK.DovizKuru) as Isksuz_Satir_Toplami,              
sum ( CASE WHEN ((FaturaMiktari* BirimFiyat*BirimMiktar) -STK.Tutar) <0.1 THEN 0 ELSE ((FaturaMiktari* BirimFiyat*BirimMiktar) -STK.Tutar)/STK.DovizKuru END  ) as SatirIskontoToplami,              
cast( sum (CASE WHEN (STK.Tutar -(SonTutar-STK.KdvTutari) )/STK.DovizKuru <0.1 THEN 0 ELSE (STK.Tutar -(SonTutar-STK.KdvTutari) )/STK.DovizKuru END ) as decimal(15,2))   
 as Alt_Iskonto_Toplami,               
sum ((SonTutar-STK.KdvTutari)/STK.DovizKuru) as  
KdvsizSatirToplami,              
sum (STK.KdvTutari/STK.DovizKuru) as KdvToplami,                
sum(STK.Tutar/STK.DovizKuru)-sum(isnull(t.TevkifatTutari,0)) as Tutar,              
sum(SonTutar/STK.DovizKuru)-sum(isnull(t.TevkifatTutari/STK.DovizKuru,0)) as SonTutar,          
t.Kod TevkifatKod,tb.TevkifatAdi TevkifatAd,convert(decimal, (t.TevkifatOrani)) TevkifatOrani,sum(t.TevkifatTutari/STK.DovizKuru) TevkifatTutari              
 from STOKHAR STK              
  inner join STOKHARDETBAG STB ON STB.IslemNo=STK.IslemNo    
   left join Tevkifat t on t.IslemNo2 = STK.IslemNo2  and t.StokNo=STK.StokNo          
   left join tblTevkifat tb on tb.Kod=t.Kod          
 where (STK.IslemTuru ='Sat' or STK.IslemTuru ='Al ade'  )              
  AND (STK.IslemNo=@IslemNo or STK.IslemNo3=@IslemNo)     
group by t.Kod,tb.TevkifatAdi,t.TevkifatOrani           
  --AND STK.Tutar>0          
   ) STK;   
   
GO
---------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_TaxSubtotalTypeName_List')
drop proc sp_mb_XML_TaxSubtotalTypeName_List
go
---------------------------------------------------------------------------------------------
CREATE   procedure [dbo].[sp_mb_XML_TaxSubtotalTypeName_List]( @IslemNo nvarchar(30)   )  
 as  
 select sum(1) as CalculationSequenceNumeric,   Oran,Deger,  
 round(sum(VergiToplami),2) "TaxAmount",  
 round(sum(XX.SonTutar-XX.VergiToplami),2) "TaxableAmount",  
 CASE WHEN Oran='KDV' and ISNULL (Deger,0)=0 THEN (SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama')       
when sum(Tutar)=0  then '351;KsmiBeldesiz'       
ELSE '' END AS  "MUAFIYET" ,VergiKodu   from (  
  
  
select  
  Oran,  
  Deger,  
  VergiTutar,  
  VergisizSatirToplami,  
  VergiToplami,  
  Isksuz_Satir_Toplami,  
  SatirIskontoToplami,  
  Alt_Iskonto_Toplami,  
  STK.SonTutar,  
  STK.Tutar,  
 VergiKodu  
   
from STOKHAR STK  
cross apply  
(  
  values   
  ('KDV', Kdv,KdvTutari , ((SonTutar-KdvTutari)/STK.DovizKuru),(KdvTutari/STK.DovizKuru),  
  (FaturaMiktari* BirimFiyat*BirimMiktar/STK.DovizKuru),  
  (((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar)/STK.DovizKuru),  
  (((Tutar -(SonTutar-KdvTutari))/STK.DovizKuru)),'0015'),  
    
  ('OTV', OTVOrani,OTVTutari, ((SonTutar-OTVTutari)/STK.DovizKuru),  
  (OTVTutari/STK.DovizKuru) ,(FaturaMiktari* BirimFiyat*BirimMiktar/STK.DovizKuru) ,  
  (((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar)/STK.DovizKuru),  
  (((Tutar -(SonTutar-OTVTutari))/STK.DovizKuru)),(select A_Muh_Kodu from STOKKARTI where StokNo=STK.StokNo))  
   
) c (Oran, Deger,VergiTutar,VergisizSatirToplami,VergiToplami,Isksuz_Satir_Toplami,SatirIskontoToplami,Alt_Iskonto_Toplami,VergiKodu)  
 where   @IslemNo in (STK.IslemNo,STK.IslemNo3)  ) XX  
 where XX.Deger>0  
 group by Oran,Deger,VergiKodu
GO

--------------------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_TaxSubtotalType_List')
drop proc sp_mb_XML_TaxSubtotalType_List
go
--------------------------------------------------------------------------------------------------------

create    PROCEDURE  [dbo].[sp_mb_XML_TaxSubtotalType_List]    
 @IslemNo nvarchar(30)    
 AS     
    
select     
round(STK.KdvToplami,2) AS "TaxAmount",    
round(STK.SonTutar-STK.KdvToplami,2) AS "TaxableAmount",     
STK.sayi AS "CalculationSequenceNumeric",     
Kdv as "KDV_ORANI" ,     
CASE WHEN ISNULL (Kdv,0)=0 THEN (SELECT Deger FROM Parametre WHERE Param='eFaturaMuafiyetAciklama')     
when STK.Tutar=0  then '351;KsmiBeldesiz'     
ELSE '' END AS  "MUAFIYET"    
 FROM    
(SELECT     
sum(1) as sayi,    
sum (FaturaMiktari* BirimFiyat*BirimMiktar/STK.DovizKuru) as Isksuz_Satir_Toplami,    
sum (((FaturaMiktari* BirimFiyat*BirimMiktar) -Tutar)/STK.DovizKuru) as SatirIskontoToplami,    
cast( sum (((Tutar -(SonTutar-KdvTutari))/STK.DovizKuru)) as decimal(15,2)) as Alt_Iskonto_Toplami,     
sum ((SonTutar-KdvTutari)/STK.DovizKuru) as KdvsizSatirToplami,    
sum (KdvTutari/STK.DovizKuru) as KdvToplami,      
sum(Tutar/STK.DovizKuru) as Tutar,    
sum(SonTutar/STK.DovizKuru) as SonTutar,    
Kdv      
 from STOKHAR STK  where (IslemTuru ='Sat' or IslemTuru ='Al ade'  )    
  AND  (STK.IslemNo=@IslemNo or STK.IslemNo3=@IslemNo)    
 -- AND Tutar>0    
 group by Kdv,OTVOrani) STK; 
GO

--------------------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='sp_mb_XML_VergiNoList')
drop proc sp_mb_XML_VergiNoList
go
--------------------------------------------------------------------------------------------------------
CREATE proc [dbo].[sp_mb_XML_VergiNoList]
 AS 
SELECT AMUSTERI.MUSVERNO   AS VERGI_NO,
AMUSTERI.MUSNO 
 FROM AMUSTERI
INNER JOIN Adres on Adres.CariNo =AMUSTERI.MUSNO
WHERE MUSNO IN 
(SELECT CariNo FROM STOKHARDETBAG WHERE FaturaTarihi > GETDATE()-60 ) 
and Adres.eFaturaMukellefimi <>'true'
GO

--------------------------------------------------------------------------------------------------------
if exists (select * from sys.procedures where name='xml_EFatura_List')
drop proc xml_EFatura_List
go
--------------------------------------------------------------------------------------------------------

CREATE PROC [dbo].[xml_EFatura_List] @IslemNo int  
as 
EXEC sp_mb_XML_InvoiceLine_List @IslemNo 
EXEC sp_mb_XML_InvoiceLine_List_delphi @IslemNo 
EXEC sp_mb_XML_InvoiceLine_List_Grup @IslemNo 
EXEC sp_mb_XML_TaxSubtotalType_List @IslemNo 
EXEC sp_mb_XML_TaxLegalMonetary_List @IslemNO 
EXEC sp_mb_XML_DespatchAdvice_List @IslemNo 
EXEC sp_mb_XML_AccountingSupplierParty_List @IslemNo 
EXEC sp_mb_XML_Customer_List_delphi @IslemNo 
EXEC sp_mb_XML_Customer_List @IslemNo 
 
select FaturaMiktari,BirimFiyat,BirimMiktar, STK.Tutar from STOKHAR STK where @IslemNo  in (STK.IslemNo,STK.IslemNo3)
GO

DELETE GridView WHERE KayitIsmi = 'FrmFaturaIslemlericxGrid1cxGrid1DBTableView1'
GO
CREATE OR ALTER  PROCEDURE [dbo].[sp_FaturaIslemleriListesi]                                                  
  @tarih1 varchar(20),                                                   
  @tarih2 varchar(20),                                                  
  @dep varchar(500),                                                  
  @orderby int,                                                  
  @arama varchar(100),                                                  
  @GosterilecekKayit int,                                                  
  @IslemTuru varchar(20),                                                  
  @Durumu int,                                      
  @IslemTipi  varchar(30),                          
  @FatSerNo  varchar(3),                          
  @eFaturaNo  varchar(30),                          
  @FaturaTuru varchar(1),              
  @IslemNoLike bit = 0,                
  @TP varchar(2) = 'TF'    
AS                                                  
                      
declare @str nvarchar(max)                                                  
declare @rc int                                                   
declare @tmp table (trc int)                                                  
declare @ayrac varchar(2)                          
declare @peFaturaNo varchar(50)                  
if @eFaturaNo<>''                  
select @peFaturaNo=UPPER(@eFaturaNo)                  
else set @peFaturaNo=''                  
set @ayrac='"';       
      
declare @tstr varchar(100);      
      
if @orderby in (0,8,9)                                                  
  set @tstr='IslemNo DESC'                                                  
if @orderby=1                                                   
 set @tstr='FaturaNo DESC,IslemNo DESC'                                                   
if @orderby=2                                                   
 set @tstr='CariAdi DESC,IslemNo DESC'                                                  
if @orderby=3                                                   
 set @tstr='CariKodu DESC,IslemNo DESC'                                                   
if @orderby=4                                                  
 set @tstr='KULADI DESC,IslemNo DESC'                                                  
if @orderby=5                                                  
 set @tstr='SaticiAdi DESC,IslemNo DESC'                                        
if @orderby=6                                                  
 set @tstr='eFaturaDurumu DESC,IslemNo DESC'                           
 if @orderby=7                                                  
 set @tstr='YaziciCount DESC,IslemNo DESC'                           
                    
set @str='select * from (select TOP ' + CAST(@GosterilecekKayit as nvarchar(10)) + ' ROW_NUMBER() over (order by '+@tstr+') as sira,'''' as plaka,*'+         
            ' from STOKHARDETBAG where FisTuru = ''F'' AND TP = '''+ @TP + ''' AND FaturaTarihi >='''+ @Tarih1+ ''' and FaturaTarihi <= '''+@Tarih2+'''';               
          
if @peFaturaNo<>''                          
set @str=@str+'and upper(eFaturaNo) like upper(''%'+@peFaturaNo+'%'') '             
          
if @FatSerNo<>''                          
set @str=@str+'and Replace(FatSerNo,'''''''','''+@ayrac+''') = '''+@FatSerNo+''' '            
                                             
if @dep <> ''                                                  
 set @str=@str+' and Departman in ('+@Dep+')'                                                  
if @IslemTuru <> 'Tm'                                                  
 set @str=@str+' and IslemTuru = '''+@IslemTuru+''''                                    
if @IslemTipi <> 'Tm' and   @IslemTipi <> ''                                                 
 set @str=@str+' and IslemTipi like ''%'+@IslemTipi+'%'''                                        
              
if @arama <> ''               
begin              
if @orderby=0               
begin              
 if @IslemNoLike = 0              
 set @str=@str+'and CAST(IslemNo as nvarchar(20)) = '''+@arama+''' '               
 else              
 set @str=@str+'and IslemNo like ''%'+@arama+'%'' '               
end;                                                
if @orderby=1                                                   
 set @str=@str+'and upper(FaturaNo) like upper('''+@arama+'%'') '                                                   
if @orderby=2                                                   
 set @str=@str+'and upper(CariAdi) like upper(''%'+@arama+'%'') '                                                  
if @orderby=3                                                   
 set @str=@str+'and upper(CariKodu) like upper('''+@arama+'%'') '                                                   
if @orderby=4                                                  
 set @str=@str+'and upper(KULADI) like upper(''%'+@arama+'%'') '                                                  
if @orderby=5                                                  
 set @str=@str+'and upper(SaticiAdi) like upper(''%'+@arama+'%'') '                                       
 if @orderby=6                                                  
 set @str=@str+'and upper(eFaturaDurumu) like upper(''%'+@arama+'%'') '                                       
if @orderby=7                                                  
 set @str=@str+'and upper(YaziciCount) like upper(''%'+@arama+'%'') '                                       
if @orderby=8                                                  
 set @str=@str+'and upper(FaturaTarihi) like upper(''%'+@arama+'%'') '                     
if @orderby=9                                                  
 set @str=@str+'and ((upper(Ack1) like upper(''%'+@arama+'%'')) or (upper(Ack2) like upper(''%'+@arama+'%'')) or (upper(Ack3) like upper(''%'+@arama+'%'')) or (upper(Ack4) like upper(''%'+@arama+'%''))             
   or EXISTS (Select 1 from ACARI AC where AC.ISLEMNO = IslemNo and upper(Aciklama2) like upper(''%'+@arama+'%''))            
      or EXISTS (Select 1 from ACIKLAMA AC where AC.FATURANO = IslemNo and upper(TeslimEden) like upper(''%'+@arama+'%''))            
      or EXISTS (Select 1 from ACIKLAMA AC where AC.FATURANO = IslemNo and upper(TeslimAlan) like upper(''%'+@arama+'%''))) '               
end;                                              
set @str=@str+')tbl ORDER BY IslemNo';                                                                    
                                                                   
--print @str      
  
execute sp_executesql  @str 
go
CREATE OR ALTER PROCEDURE sp_DepartmanKayitGoster
AS
BEGIN
	declare @Sorgu nvarchar(max);
	declare @tablename nvarchar(50)
	declare csr_dep cursor for 	
		SELECT t.name
		  FROM sys.tables t,
			   sys.columns c
		 WHERE t.object_id = c.object_id
		   AND c.name = 'Departman';
	SET @Sorgu = '';
	open csr_dep
	fetch next from csr_dep into @tablename
	while @@FETCH_STATUS = 0
	begin			
		IF @Sorgu = ''
			SET @Sorgu = ' Select '''+@tablename+''' as TabloAdi,Departman,count(*) KayitSayisi from ' + @tablename + ' GROUP BY Departman';
		ELSE
			SET @Sorgu = @Sorgu + ' UNION ALL Select '''+@tablename+''' as TabloAdi,Departman,count(*) KayitSayisi from ' + @tablename + ' GROUP BY Departman';	
			
	fetch next from csr_dep into @tablename
	end
	close csr_dep
	deallocate csr_dep
	EXEC sp_executesql @Sorgu;  
END;

--exec sp_DepartmanKayitGoster
go

UPDATE Parametre SET Deger=	500 WHERE Param='Bilgi Gnderme BeklemeSresi'

EXEC sp_rename 'ISOBIRIM.ISOId'  ,'Id' , 'COLUMN'
go
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
           WHERE TABLE_NAME = 'Kullanicilar' AND COLUMN_NAME = 'IYTED')
BEGIN
    ALTER TABLE Kullanicilar DROP COLUMN IYTED;
END
 go
 IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
           WHERE TABLE_NAME = 'Kullanicilar' AND COLUMN_NAME = 'IYTSD')
BEGIN
     ALTER TABLE Kullanicilar DROP COLUMN IYTSD
END

 go
create or alter trigger ACariBakiye 
on ACARI
after UPDATE, INSERT, DELETE
as
declare @MUSNO int
if exists(SELECT * from inserted) and exists (SELECT * from deleted)
begin   
    SELECT @MUSNO = MUSNO from inserted i;    
end

If exists (Select * from inserted) and not exists(Select * from deleted)
begin
    SELECT @MUSNO = MUSNO from inserted i;    
end

If exists(select * from deleted) and not exists(Select * from inserted)
begin     
    SELECT @MUSNO = MUSNO from deleted i;   
end

UPDATE m SET m.MUSBORC   = BORC,
			 m.MUSALACAK = ALACAK, 
			 m.MUSBAKIYE = BAKIYE 
  from AMUSTERI m ,
	   (Select MUSNO,SUM(BORC) BORC,SUM(ALACAK) ALACAK,SUM(BORC - ALACAK) BAKIYE from ACARI GROUP BY MUSNO) c
 where c.MUSNO = m.MUSNO 
   and  c.MUSNO = @MUSNO 
   AND NOT EXISTS ( select 'x' from KullaniciAyarlari k where Ayar = 'PesinCariNo' AND Deger = m.MUSNO)
go
CREATE or alter PROCEDURE  sp_DovizliTakip (@DovizKodu nvarchar(2),@DovizliTakip bit = 0,@DovizKur float = 1)
AS
BEGIN
	--exec sp_DovizliTakip 'TL'
	Declare @NoId int
	declare @DovizAdi nvarchar(20)

	Select @NoId = NoId,@DovizAdi = DovizAdi from DOVIZT where DovizKodu = @DovizKodu;

	IF @DovizliTakip = 0 
	BEGIN
		/*UPDATE STOKHAR SET DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizAlacak = A  
		--select DovizCinsi, DovizKodu,DovizAlacak,DovizBorc,DovizKur,DovizTut,DovizTutB from STOKHARDETBAG  
		  select DovizCinsi,DovizKodu from SIPARISHAR    
		  union    
		  select DovizCinsi,DovizKodu from SIPARISHARDETBAG    
		  union    
		  select DovizCinsi,DovizKodu from TEKLIFHAR    
		  union    
		  select DovizCinsi,DovizKodu from TEKLIFHARDETBAG  */
		UPDATE KASAT SET  DovizNoId = @NoId,DovizKodu = @DovizKodu,DovizAdi = @DovizAdi;
		UPDATE ACARI SET  DOVIZCINSI = @NoId,DOVIZKODU = @DovizKodu,DOVIZTUT = BORC + ALACAK,DovizAlacak = ALACAK,DovizBorc = BORC,DovizKur = @DovizKur;
		UPDATE HESAPLAR SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizAdi = @DovizAdi;
		UPDATE BANKA SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizBorc = BORC, DovizAlacak = ALACAK, DovizTut = BORC + ALACAK;
		UPDATE BORDRO SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizBorc = TUTAR;
		UPDATE CEK SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizBorc = TUTAR,CekParaBirimi = @DovizKodu;
	    UPDATE GELGID SET  DOVIZCINSI = @NoId,DOVIZKODU = @DovizKodu,DOVIZTUT = BORC + ALACAK,DovizAlacak = ALACAK,DovizBorc = BORC,DovizKuru = @DovizKur;
		UPDATE KASA SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizBorc = BORC, DovizAlacak = ALACAK, DovizTut = BORC + ALACAK,DovizKur = @DovizKur;
		UPDATE Visa SET  DovizCinsi = @NoId,DovizKodu = @DovizKodu,DovizTut = BORC + ALACAK;
	    UPDATE KullaniciAyarlari SET Deger = @DovizAdi where Ayar = 'VarsayilanDovizAdi';
		UPDATE KullaniciAyarlari SET Deger = @NoId where Ayar = 'VarsayilanDovizId';
		UPDATE KullaniciAyarlari SET Deger = @DovizKodu where Ayar = 'VarsayilanDovizKodu';
	END;
END;   
go
create OR ALTER VIEW [dbo].[Vstk_DepoDurumlari]             
AS      --  SELECT * FROM Vstk_DepoDurumlari      
select *  from      
(select SK.StokNo, Kodu  ,Kodu StokKodu  , SK.StokAdi , GrupAdi , UreticiFirmaKodu , OzelKod1 , OzelKod2,  SK.AnaBirim , AktifPasif ,           
(select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'G' and Depo = SH.Depo)     as [Giris],            
(select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'C' and Depo = SH.Depo)     as [Cks],            
((select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'G' and Depo = SH.Depo)  -            
 (select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'C' and Depo = SH.Depo)            
)            
    as [StokAdedi],            
 Depo, AsgariAdet,AzamiAdet,OlmasiGerekenAdet    
from   STOKKARTI as SK  LEFT JOIN STOKHAR SH ON SH.StokKodu=SK.Kodu          
WHERE SK.AktifPasif='A'      
group by SK.StokNo,Kodu ,   SK.StokAdi , GrupAdi , UreticiFirmaKodu , OzelKod1 , OzelKod2,  SK.AnaBirim , AktifPasif , SH.Depo,AsgariAdet,AzamiAdet,OlmasiGerekenAdet -- having  AktifPasif='A'       
)T  WHERE ((StokAdedi > 0.01) OR (EXISTS (Select 1 from Parametre Where Param = 'Envanter Raporlarnda Sfrn Alt Grnsn' AND Deger = '-1') AND StokAdedi < 0))
--order by StokAdedi 
go
CREATE or alter PROCEDURE sp_Grup_Bakim      
AS        
BEGIN   
 -- UreticiFirma Ad insert  STOKKARTI
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT UreticiFirmaKodu,'U',1,'Admin' from STOKKARTI         
 where UreticiFirmaKodu <> '' and UreticiFirmaKodu is not null        
   and NOT EXISTS (Select 1 from GRUP where GrupAdi = UreticiFirmaKodu and Turu = 'U')        
        
   -- Grup Ad insert   STOKKARTI     
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT GrupAdi,'G',1,'Admin' from STOKKARTI sk        
 where GrupAdi <> '' and GrupAdi is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = sk.GrupAdi and g.Turu = 'G')        
  
  -- Web Grup Ad insert   STOKKARTI     
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT GrupAdi,'W',1,'Admin' from STOKKARTI sk        
 where GrupAdi <> '' and GrupAdi is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = sk.GrupAdi and g.Turu = 'W')        
 
   --Alt1 Grup Ad insert   STOKKARTI     
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT AltGrupAdi,'48',1,'Admin' from STOKKARTI sk        
 where GrupAdi <> '' and GrupAdi is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = sk.GrupAdi and g.Turu = '48')        
 
    --Alt2 Grup Ad insert   STOKKARTI     
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT AltGrupAdi2,'49',1,'Admin' from STOKKARTI sk        
 where GrupAdi <> '' and GrupAdi is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = sk.GrupAdi and g.Turu = '49')        
 
 -- Cari Tip nsert        
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT Tipi,'T',1,'Admin' from AMUSTERI m        
 where Tipi <> '' and Tipi is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = m.Tipi and g.Turu = 'T')        
        
 -- Cari O1 nsert        
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT OZELKOD1,'O1',1,'Admin' from AMUSTERI m        
 where OZELKOD1 <> '' and OZELKOD1 is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = m.OZELKOD1 and g.Turu = 'O1')        
        
 -- Cari O2 nsert        
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT OZELKOD2,'O2',1,'Admin' from AMUSTERI m        
 where OZELKOD2 <> '' and OZELKOD2 is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = m.OZELKOD2 and g.Turu = 'O2')        
        
 -- Cari O3 nsert        
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT OZELKOD3,'O3',1,'Admin' from AMUSTERI m        
 where OZELKOD3 <> '' and OZELKOD3 is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = m.OZELKOD3 and g.Turu = 'O3')        
        
 -- Cari O4 nsert        
 INSERT INTO GRUP (GrupAdi,Turu,KULNO,KULADI)        
 select DISTINCT OZELKOD4,'O4',1,'Admin' from AMUSTERI m        
 where OZELKOD4 <> '' and OZELKOD4 is not null        
   and NOT EXISTS (Select 1 from GRUP g where g.GrupAdi = m.OZELKOD4 and g.Turu = 'O4')        
        
END;  
go
IF EXISTS (
    SELECT * 
    FROM sys.default_constraints 
    WHERE parent_object_id = OBJECT_ID('dbo.Kullanicilar') 
    AND name = 'DF_Kullanicilar_Departman'
)
BEGIN
    ALTER TABLE [dbo].[Kullanicilar] DROP CONSTRAINT [DF_Kullanicilar_Departman];
END
GO

BEGIN
    ALTER TABLE Kullanicilar ADD CONSTRAINT DF_Kullanicilar_Departman DEFAULT '01000000' FOR Departman;
END

--ALTER TABLE Kullanicilar ADD CONSTRAINT DF_Kullanicilar_Departman DEFAULT (('01000000')) FOR Departman
go
create or alter proc sp_Stok_Kart_Barkod_Fiyat_Const_DltIns 
as 

declare @CNTNAME NVARCHAR(100),@TBLNAME NVARCHAR(100),@SQL NVARCHAR(MAX) , @i int =0
create table ##UQConst_Liste (sorgu nvarchar(max) null,Update_Date datetime)
WHILE @i <=30
BEGIN
select @CNTNAME=CONST_ADI ,@TBLNAME=TABLO_ADI  FROM (
SELECT T.name TABLO_ADI ,K.name CONST_ADI,K.type  FROM sys.key_constraints K ,sys.tables T where T.object_id=K.parent_object_id AND K.type='UQ' ) A 
	WHERE TABLO_ADI IN ('STOKKARTI','StokBarkodlari','StokFiyat')   and CONST_ADI<> 'STK_UQN'
print ('---'+@CNTNAME +'---'+ @TBLNAME)
SET @SQL='ALTER TABLE [dbo].['+@TBLNAME+'] DROP CONSTRAINT ['+ CONVERT(VARCHAR(200),@CNTNAME)+']'
 EXEC(@SQL)
print (@SQL)
 insert into ##UQConst_Liste (sorgu ,Update_Date ) select  @SQL ,GETDATE()
 print (@SQL)
 EXEC (@SQL)
PRINT (@SQL) 
set @i=@i+1
END 
go
-- select * from ##UQConst_Liste
exec  sp_Stok_Kart_Barkod_Fiyat_Const_DltIns
go
drop table ##UQConst_Liste
go 
---##UQConst_Liste  NERDE OLUUYOR.
select * from sys.key_constraints where type ='UQ'
SELECT T.name TABLO_ADI ,K.name CONST_ADI,K.type  FROM sys.key_constraints K ,sys.tables T where T.object_id=K.parent_object_id AND K.type='UQ'  
--	WHERE TABLO_ADI IN ('STOKKARTI','StokBarkodlari','StokFiyat') -- and CONST_ADI<> 'STK_UQN'


---- UNIQUE CONST STOKKARTLARI

 ALTER TABLE [dbo].[STOKKARTI] ADD  CONSTRAINT [UQSTK_KOD] UNIQUE NONCLUSTERED ([Kodu] ASC)  WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY]
GO
ALTER TABLE [dbo].[STOKKARTI] ADD  CONSTRAINT [UQSTK_StokNo] UNIQUE NONCLUSTERED ([StokNo] ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY]
GO
ALTER TABLE [dbo].[STOKKARTI] ADD  CONSTRAINT [UQSTK_BARKOD] UNIQUE NONCLUSTERED ([Barkodu] ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY]
GO
ALTER TABLE [dbo].[StokFiyat] ADD  CONSTRAINT [UQ_STKFyt_KOD] UNIQUE NONCLUSTERED ([Kodu] ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY]
GO
ALTER TABLE [dbo].[StokFiyat] ADD  CONSTRAINT [UQ_STKFyt_StokNo] UNIQUE NONCLUSTERED ([StokNo] ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON ) ON [PRIMARY]
GO
ALTER TABLE [dbo].[StokBarkodlari] ADD  CONSTRAINT [UQ_STKBrk_Barkodu] UNIQUE NONCLUSTERED ([Barkodu] ASC) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF,  IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON )ON[PRIMARY]
GO


--   select * from sys.key_constraints where type ='UQ'
SELECT T.name TABLO_ADI ,K.name CONST_ADI,K.type  FROM sys.key_constraints K ,sys.tables T where T.object_id=K.parent_object_id AND K.type='UQ'  
--	WHERE TABLO_ADI IN ('STOKKARTI','StokBarkodlari','StokFiyat') -- and CONST_ADI<> 'STK_UQN'
GO
UPDATE STOKKARTI    SET Departman = (Select Deger from KullaniciAyarlari where KullaniciNo = 1 and Ayar = 'VarsayilanDepartmanDuzeyi') 
 WHERE ISNULL(Departman,'x') = 'x'
go
 UPDATE  sk     SET StokAdedi = (SELECT ISNULL(SUM(Miktar), 0) from STOKHAR 
				      WHERE StokKodu = sk.Kodu and GC='G' and FisTuru<>'')-
					(SELECT ISNULL(SUM(Miktar), 0) from STOKHAR 
					  WHERE StokKodu = sk.Kodu and GC='C' and FisTuru<>'') 
	FROM STOKKARTI sk
   WHERE sk.StokTipi in ('+ rn','+ Ambalaj','+ Demirba')
     AND StokAdedi is null
go
ALTER TABLE [dbo].[STOKKARTI] ADD  CONSTRAINT [DF_STOKKARTI_StokAdedi]  DEFAULT ((0)) FOR [StokAdedi]
go
IF EXISTS (SELECT * FROM sys.triggers WHERE name = 'StokFiyat_StokNo')
BEGIN
    DROP TRIGGER StokFiyat_StokNo;
END
GO   
create  trigger StokFiyat_StokNo on StokFiyat  AFTER INSERT    
as      
begin     
 Declare @Kodu nvarchar(30) 
  	select @Kodu = Kodu from inserted    
	update StokFiyat set StokNo=(select top 1  StokNo from STOKKARTI where Kodu=StokFiyat.Kodu ) where  Kodu=@Kodu;
	update StokBarkodlari set StokNo=(select top 1  StokNo from STOKKARTI where Kodu=StokBarkodlari.StokKodu ) where  StokKodu=@Kodu;
end;   
GO

ENABLE TRIGGER StokFiyat_StokNo on StokFiyat
GO
update StokBarkodlari set AnaBirim=0 where Carpani<>1
go
 
IF EXISTS (SELECT * FROM sys.procedures WHERE name = 'sp_GunlukDurumRaporu')
BEGIN
    DROP proc [sp_GunlukDurumRaporu];
END
go
 create  procedure [dbo].[sp_GunlukDurumRaporu](@Tarih1 DATETIME,@Tarih2 DATETIME,@Tip nvarchar(1),@KulNo nvarchar (5) = null)  
AS
//----sp_GunlukDurumRaporu '20240404','20240505','T'//
BEGIN
    DECLARE @SQL nvarchar(max);
	DECLARE @Fiyat nvarchar(30);
    DECLARE @KulNoStr nvarchar(30);  
	select @Fiyat = Deger from  Parametre where Param = 'Gnlk Kar Raporu Kullanlacak Fiyat';

	IF (@Fiyat = '') OR (@Fiyat IS NULL)
	BEGIN
		SET @Fiyat = 'StokKartiFiyat1';
	END;


 IF @KulNo IS NULL
	 BEGIN
		SET @KulNoStr = '';  
	 END
	 ELSE
	 BEGIN
		SET @KulNoStr = ' AND sh.KULNO = ' + @KulNo;  
	 END; 

IF @Tip = 'T'   ---'Fatura Toplami' Turu,IslemTuru,  '' NakitVisa, 
	BEGIN
	SET @SQL=' select  1 No , ''Fatura Toplami'' Turu, CASE WHEN IslemTuru = ''Prk.Sat'' THEN ''Veresiye Prk.Sat'' ELSE IslemTuru END IslemTuru  ,'''' NakitVisa,      
					   sum(Miktar*BirimFiyat*(100+Kdv)/100) IskontosuzTutar, 
					   sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) IskTop,
					   sum(Miktar*BirimFiyat*(100+Kdv)/100) + sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) Tutar, 
					   SUM((sh.SonTutar + ISNULL(sh.SatMasrafTutari,0)) - (sh.Miktar * sf.'+@Fiyat+')) AS Karlilik
					  from STOKHAR  sh
				LEFT JOIN StokFiyatlari sf on sf.StokNo = sh.StokNo
				LEFT JOIN KASA K ON K.ISLEMNO=sh.IslemNo
				where FisTuru=''F'' and IslemTuru in (''Sat'' ,''Al'' ,''Al ade'' ,''Sat ade'',''Prk.Sat'') 
				AND  not exists( Select 1 from KASA K where K.ISLEMNO = sh.IslemNo)	
				AND  sh.FaturaTarihi >= ''@Tarih1'' and sh.FaturaTarihi <= ''@Tarih2'''+ @KulNoStr +'
				group by IslemTuru
				UNION ALL	
				SELECT 2,IslemTuru, k.BAACIKLA,NakitVisa,      
						sum(Miktar*BirimFiyat*(100+Kdv)/100) IskontosuzTutar, 
						sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) IskTop,
						sum(Miktar*BirimFiyat*(100+Kdv)/100) + sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) Tutar, 
						SUM((sh.SonTutar + ISNULL(sh.SatMasrafTutari,0)) - (sh.Miktar * sf.'+@Fiyat+')) AS Karlilik
				from STOKHAR sh 
				left JOIN KASA k ON k.ISLEMNO = sh.IslemNo
				LEFT JOIN StokFiyatlari sf on sf.StokNo = sh.StokNo
				WHERE  FisTuru=''F'' AND (sh.IslemTuru = ''Prk.Sat'') AND k.BAACIKLA IN (''KK.Tahsilat'',''Tahsilat'')
				 AND  sh.FaturaTarihi >= ''@Tarih1'' and sh.FaturaTarihi <= ''@Tarih2'''+ @KulNoStr +'
				GROUP BY sh.IslemTuru,k.BAACIKLA,NakitVisa 
				UNION ALL 
				select 3,''Dier Kasa Hareketleri'',BAACIKLA,'''' , SUM(BORC) Tutar,0,0,''''from KASA sh where BAACIKLA IN (''KK.Tahsilat'',''Tahsilat'') 
				and not exists (select 1 from STOKHARDETBAG db where db.IslemNo = sh.ISLEMNO)
				and TARIH >= ''@Tarih1'' and TARIH <= ''@Tarih2'' '+ @KulNoStr +'	
				group by BAACIKLA
				UNION ALL 
				select 4,''Fatural Kasa Hareketleri'',BAACIKLA,'''', SUM(BORC) Tutar,0,0,''''  from KASA sh where BAACIKLA IN (''KK.Tahsilat'',''Tahsilat'') 
				and exists (select 1 from STOKHARDETBAG db where db.IslemNo = sh.ISLEMNO)
				and TARIH >= ''@Tarih1'' and TARIH <= ''@Tarih2'' '+ @KulNoStr +'	
				group by BAACIKLA
				UNION ALL
				SELECT 5,''ek -Senet Girileri'',BAACIKLA,'''',SUM(sh.ALACAK) AS TUTAR,0,0,''''  FROM dbo.ACARI sh 
				WHERE BAACIKLA in(''ek Girii'',''Senet Girii'') and  TARIH >= ''@Tarih1'' and TARIH <= ''@Tarih2'' '+ @KulNoStr +'	
				group by BAACIKLA	
				UNION ALL
				SELECT 6,''deme Islemleri'',BAACIKLA,'''',SUM(sh.BORC) AS TUTAR,0,0,'''' FROM dbo.ACARI sh
				WHERE BAACIKLA = ''deme'' and  TARIH >= ''@Tarih1'' and TARIH <= ''@Tarih2'' '+ @KulNoStr +'	
				group by BAACIKLA order by 1'; 
    END
	ELSE IF @Tip = 'D'
	BEGIN
	SET @SQL=' select  IslemNo,m.MUSKOD,m.MUSADI,sh.StokKodu,ISNULL(sk.StokAdi,sh.StokAdi) StokAdi,SUM(sh.SonTutar/sh.Miktar) NetFiyat,SUM(sh.Miktar) Miktar,
					  ''Fatura Toplami'' Turu, CASE WHEN IslemTuru = ''Prk.Sat'' THEN ''Veresiye Prk.Sat'' ELSE IslemTuru END IslemTuru  ,'''' NakitVisa,      
					   sum(Miktar*BirimFiyat*(100+Kdv)/100) IskontosuzTutar, 
					   sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) IskTop,
					   sum(Miktar*BirimFiyat*(100+Kdv)/100) + sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) Tutar, 
					   SUM((sh.SonTutar + ISNULL(sh.SatMasrafTutari,0)) - (sh.Miktar * sf.'+@Fiyat+')) AS Karlilik
					  from STOKHAR  sh
				LEFT JOIN STOKKARTI sk on sk.Kodu = sh.StokKodu
				LEFT JOIN AMUSTERI m on m.MUSNO = sh.CariNo
				LEFT JOIN StokFiyatlari sf on sf.StokNo = sh.StokNo
				LEFT JOIN KASA K ON K.ISLEMNO=sh.IslemNo
				where FisTuru=''F'' and IslemTuru in (''Sat'' ,''Al'' ,''Al ade'' ,''Sat ade'',''Prk.Sat'') 
				AND  not exists( Select 1 from KASA K where K.ISLEMNO = sh.IslemNo)	
				AND  sh.FaturaTarihi >= ''@Tarih1'' and sh.FaturaTarihi <= ''@Tarih2'''+ @KulNoStr +'
				group by IslemNo,IslemTuru,m.MUSADI,m.MUSKOD,sh.StokKodu,sk.StokAdi,sh.StokAdi
				UNION ALL	
				SELECT  IslemNo,m.MUSKOD,m.MUSADI,sh.StokKodu,ISNULL(sk.StokAdi,sh.StokAdi) StokAdi,
						SUM(sh.SonTutar/sh.Miktar) NetFiyat,
						SUM(sh.Miktar) Miktar,
						IslemTuru, k.BAACIKLA,NakitVisa,      
						sum(Miktar*BirimFiyat*(100+Kdv)/100) IskontosuzTutar, 
						sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) IskTop,
						sum(Miktar*BirimFiyat*(100+Kdv)/100) + sum(SonTutar-(Miktar*BirimFiyat*(100+Kdv)/100)) Tutar, 
						SUM((sh.SonTutar + ISNULL(sh.SatMasrafTutari,0)) - (sh.Miktar * sf.'+@Fiyat+')) AS Karlilik
				from STOKHAR sh 
				LEFT JOIN STOKKARTI sk on sk.Kodu = sh.StokKodu
				LEFT JOIN AMUSTERI m on m.MUSNO = sh.CariNo
				left JOIN KASA k ON k.ISLEMNO = sh.IslemNo
				LEFT JOIN StokFiyatlari sf on sf.StokNo = sh.StokNo
				WHERE  FisTuru=''F'' AND (sh.IslemTuru = ''Prk.Sat'') AND k.BAACIKLA IN (''KK.Tahsilat'',''Tahsilat'')
				 AND  sh.FaturaTarihi >= ''@Tarih1'' and sh.FaturaTarihi <= ''@Tarih2'''+ @KulNoStr +'
				GROUP BY IslemNo,sh.IslemTuru,k.BAACIKLA,NakitVisa, m.MUSADI,m.MUSKOD,sh.StokKodu,sk.StokAdi,sh.StokAdi';
	END;

	SET @sql =  REPLACE(@Sql,'@Tarih1',@Tarih1)
	SET @sql =  REPLACE(@Sql,'@Tarih2',@Tarih2)		
--	PRINT @SQL
	EXEC sp_executesql  @sql;
END;
GO


CREATE or alter FUNCTION [dbo].[SplitString]
(    
      @Input NVARCHAR(MAX),
      @Character CHAR(1)
)
RETURNS @Output TABLE (
      Item NVARCHAR(1000)
)
AS
BEGIN
      DECLARE @StartIndex INT, @EndIndex INT

      SET @StartIndex = 1
      IF SUBSTRING(@Input, LEN(@Input) - 1, LEN(@Input)) <> @Character
      BEGIN
            SET @Input = @Input + @Character
      END

      WHILE CHARINDEX(@Character, @Input) > 0
      BEGIN
            SET @EndIndex = CHARINDEX(@Character, @Input)

            INSERT INTO @Output(Item)
            SELECT SUBSTRING(@Input, @StartIndex, @EndIndex - 1)

            SET @Input = SUBSTRING(@Input, @EndIndex + 1, LEN(@Input))
      END

      RETURN
END
go

create OR ALTER VIEW [dbo].[Vstk_DepoDurumlari]             
AS      --  SELECT * FROM Vstk_DepoDurumlari      
select *  from      
(select SK.StokNo, Kodu  ,Kodu StokKodu  , SK.StokAdi , GrupAdi , UreticiFirmaKodu , OzelKod1 , OzelKod2,  SK.AnaBirim , AktifPasif ,           
(select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'G' and Depo = SH.Depo)     as [Giris],            
(select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'C' and Depo = SH.Depo)     as [Cks],            
((select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'G' and Depo = SH.Depo)  -            
 (select ISNULL(SUM(Miktar), 0)      from STOKHAR         where StokKodu = SK.Kodu and GC = 'C' and Depo = SH.Depo)            
)            
    as [StokAdedi],            
 Depo, AsgariAdet,AzamiAdet,OlmasiGerekenAdet    
from   STOKKARTI as SK  LEFT JOIN STOKHAR SH ON SH.StokKodu=SK.Kodu          
WHERE SK.AktifPasif='A'      
group by SK.StokNo,Kodu ,   SK.StokAdi , GrupAdi , UreticiFirmaKodu , OzelKod1 , OzelKod2,  SK.AnaBirim , AktifPasif , SH.Depo,AsgariAdet,AzamiAdet,OlmasiGerekenAdet -- having  AktifPasif='A'       
)T  WHERE ((StokAdedi > 0.01) OR (EXISTS (Select 1 from Parametre Where Param = 'Envanter Raporlarnda Sfrn Alt Grnsn' AND Deger = '-1') AND StokAdedi < 0))
--order by StokAdedi 
GO


if not exists (SELECT 1 FROM VTGuncellemeleri WHERE VTVersiyon='7.2.5')
BEGIN
insert into VTGuncellemeleri (VTVersiyon, SonIslemNo, TarihSaat, Prg)
VALUES ('7.2.5',(select ISLEMNO from ADIGSABITLER ),GETDATE(),'OM')
END
go

select top 5 * from VTGuncellemeleri order by VTVersiyon desc
   go 
